using System;
using System.Collections;
using Method = System.Reflection.MethodBase;
using System.Drawing.Printing;
using System.Data;
using System.Text;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for TransfusionEffectivenessReport.
	/// </summary>
	public class TransfusionEffectivenessReport:VbecsReport
	{
		//private bool _isAllPatients;
		private BOL.Patient _patient;
		private DataTable _transfusionEffectivenessReport;
		private DataTable _labTests;
		private ArrayList _labTestArray;
		private DataTable _transfusedUnits;
		private DataTable _labTestResults;
        private DataSet _dsReport = new DataSet();

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5413"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Initialized TransfusionEffectivnessReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5414"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty Transfusion Effectivenss Report constructor
		/// </summary>
		public TransfusionEffectivenessReport()
		{
			this.IsAllPatients = true;
			//
			GetLabTests();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5415"> 
		///		<ExpectedInput>Valid TransfusionEffectivenessReport object</ExpectedInput>
		///		<ExpectedOutput>IsAllPatients property</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5416"> 
		///		<ExpectedInput>Valid IsAllPatients flag set to false</ExpectedInput>
		///		<ExpectedOutput>Updated TransfusionEffectivenessReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5417"> 
		///		<ExpectedInput>Valid IsAllPatients flag set to true</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets value indicating whether the report is for all patients;
		/// </summary>
		public bool IsAllPatients
		{
			get
			{
				return Convert.ToBoolean(this.ParameterRow["IsAllPatients"]);
			}
			set
			{
				this.ParameterRow["IsAllPatients"] = value;
				//
				if (value)
				{
					RuleBroken("Patient",false);
				}
				else
				{
					RuleBroken("Patient",(this._patient == null));
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5418"> 
		///		<ExpectedInput>Valid TransfusionEffectivenessReport object with IsAllPatients falg set to true</ExpectedInput>
		///		<ExpectedOutput>Patient property</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5419"> 
		///		<ExpectedInput>Valid TransfusionEffectivenessReport object with IsAllPatients falg set to false</ExpectedInput>
		///		<ExpectedOutput>Business Object exception thrown</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="0" testid ="5420"> 
		///		<ExpectedInput>Valid patient object</ExpectedInput>
		///		<ExpectedOutput>Updated TransfusionEffectivenessReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5421"> 
		///		<ExpectedInput>Invalid patient object</ExpectedInput>
		///		<ExpectedOutput>Rule broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets patient for single patient reporting
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				if (this.IsAllPatients)
				{
					throw new BOL.BusinessObjectException("Report for all patients");
				}
				return this._patient;
			}
			set
			{
				this._patient = value;
				//
				RuleBroken(Method.GetCurrentMethod().Name, ((!this.IsAllPatients) && ((this._patient == null)||(this._patient.PatientGuid == Guid.Empty))));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5422"> 
		///		<ExpectedInput>Valid TransfusionEffectivenessReport object</ExpectedInput>
		///		<ExpectedOutput>DetailedReport property</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5423"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets transfusion effectiveness report data table for use in report
		/// </summary>
		public DataTable DetailedReport
		{
			get
			{
				if (this._transfusionEffectivenessReport == null)
				{
					this.GetTransfusionEffectivenessReport();
				}
				return this._transfusionEffectivenessReport;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5424"> 
		///		<ExpectedInput>Valid TransfusionEffectivenessReport object</ExpectedInput>
		///		<ExpectedOutput>Report criteria string for report footer</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5425"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets report criteria text for Transfusion Effectiveness report footer
		/// </summary>
		public string ReportCriteria
		{
			get
			{
				StringBuilder criteria = new StringBuilder();
				criteria.Append("Start Date: "+Common.VBECSDateTime.FormatDateString(this.StartDate)+"\n");
				criteria.Append("End Date: "+Common.VBECSDateTime.FormatDateTimeString(this.EndDate)+"\n");
				if (this.IsAllPatients)
				{
					criteria.Append("Patients: All Patients\n");
				}
				else
				{
					criteria.Append("Patient: "+this.Patient.DisplayName+"\n");
				}
				//
				return criteria.ToString();
			}
		}

		private DataTable GetTransfusionEffectivenessReportSchema()
		{
			DataTable dt = new DataTable("TransfusionEffectivenessReport");
			dt.Columns.Add(TABLE.Patient.VistaPatientId);
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add("PatientDisplayName");
			dt.Columns.Add(TABLE.Patient.DisplayVistaPatientId);
			dt.Columns.Add(TABLE.Patient.PatientDeathDate, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientTreatment.PatientLocation);
			dt.Columns.Add(TABLE.BloodUnit.EyeReadableUnitId);
			dt.Columns.Add(TABLE.BloodProduct.ProductShortName);
			dt.Columns.Add(TABLE.PatientTransfusion.TransfusionEndDateTime, typeof(DateTime));
			dt.Columns.Add(TABLE.SpecimenTestThreshold.VistaLaboratoryTestName);
			dt.Columns.Add(TABLE.PatientTest.TestResult);
			dt.Columns.Add(TABLE.BloodUnitTest.TestDate, typeof(DateTime));
			dt.Columns.Add(ARTIFICIAL.SortDate, typeof(DateTime));
			return dt;
		}

		private void GetLabTests()
		{
			BOL.LabTest labTest = new BOL.LabTest();
			labTest.ReportType = Common.ReportType.TransfusionEffectiveness;
			DataTable allLabTests = labTest.GetLabTests();
			//
			_labTests = allLabTests.Clone();
			_labTestArray = new ArrayList();
			//
			foreach(DataRow dr in allLabTests.Rows)
			{
				if (Common.Utility.GetRecordStatusCodeFromString(dr[TABLE.SpecimenTestThreshold.RecordStatusCode].ToString()) == Common.RecordStatusCode.Active)
				{
					_labTests.Rows.Add(dr.ItemArray);
					_labTestArray.Add(dr[TABLE.SpecimenTestThreshold.LabTestId].ToString().Trim());
				}
			}
		}

		private ArrayList GetPatientArray()
		{
			ArrayList patientArray = new ArrayList();
			//
			foreach(DataRow dr in _transfusedUnits.Rows)
			{
				if (patientArray.IndexOf(dr[TABLE.Patient.VistaPatientId].ToString())<0)
				{
					patientArray.Add(dr[TABLE.Patient.VistaPatientId].ToString());
				}
			}
			//
			return patientArray;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5426"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Transfusion Effectiveness report data created</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5427"> 
		///		<ExpectedInput>Invalid division code</ExpectedInput>
		///		<ExpectedOutput>Empty detailed Transfusion Effectiveness report data table</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Load transfusion effectiveness report for report
		/// </summary>
		public void GetTransfusionEffectivenessReport()
		{
			DataTable dtReport = this.GetTransfusionEffectivenessReportSchema();
			//
			if (this._labTestArray.Count==0)
			{
				this._transfusionEffectivenessReport = dtReport.Clone();
				return;
			}
			//
			if (this.IsAllPatients)
			{
				_transfusedUnits = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(this.StartDate, this.EndDate);
			}
			else
			{
				_transfusedUnits = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(this.StartDate, this.EndDate, this.Patient.PatientGuid);
			}
			//
			//Holds IDs of patients with transfusions and lab test results within date range
			ArrayList patientLabTestArray = new ArrayList();
			//
			try
			{
				//Holds IDs of all patients with transfusions - to use when searching VistA for Lab Test results.
				ArrayList patientTransfusionArray = this.GetPatientArray();
				if (patientTransfusionArray.Count > 0)
				{
					_labTestResults = BOL.LabTest.GetVistALabTestResults(this.StartDate, this.EndDate, Common.LogonUser.LogonUserDivisionCode, this._labTestArray, patientTransfusionArray);
					//
					foreach(DataRow dr in _labTestResults.Rows)
					{
						DataRow drReport = dtReport.NewRow();
						//
						DataRow drPatient = FindPatientInfo(dr[TABLE.Patient.VistaPatientId].ToString());
						//
						//Add patient to array of patients with transfusions and lab test results - if not already in the list
						if (patientLabTestArray.IndexOf(dr[TABLE.Patient.VistaPatientId].ToString())<0)
						{
							patientLabTestArray.Add(dr[TABLE.Patient.VistaPatientId].ToString());
						}
						//
						drReport[TABLE.Patient.VistaPatientId] = dr[Common.DatabaseConstants.VistALinkColumnNames.VistaPatientId];
						drReport[TABLE.Patient.PatientGuid] = drPatient[TABLE.Patient.PatientGuid];
						drReport[ARTIFICIAL.PatientDisplayName] = BOL.Patient.BuildDisplayName(drPatient[TABLE.Patient.PatientFirstName].ToString(),
							drPatient[TABLE.Patient.PatientMiddleName].ToString(),
							drPatient[TABLE.Patient.PatientLastName].ToString());
						drReport[TABLE.Patient.DisplayVistaPatientId] = drPatient[TABLE.Patient.DisplayVistaPatientId];
						drReport[TABLE.Patient.PatientDeathDate] = drPatient[TABLE.Patient.PatientDeathDate];
						drReport[TABLE.PatientTreatment.PatientLocation] = drPatient[TABLE.PatientTreatment.PatientLocation];
						//
						drReport[TABLE.SpecimenTestThreshold.VistaLaboratoryTestName] = dr[Common.DatabaseConstants.VistALinkColumnNames.TestPrintName];
						drReport[TABLE.PatientTest.TestResult] = dr[Common.DatabaseConstants.VistALinkColumnNames.TestResult];
						drReport[TABLE.SpecimenTest.TestDate] = dr[Common.DatabaseConstants.VistALinkColumnNames.ResultDateTime];
						drReport[ARTIFICIAL.SortDate] = dr[Common.DatabaseConstants.VistALinkColumnNames.ResultDateTime];
						//
						dtReport.Rows.Add(drReport);
					}
				}
			}
			catch (BOL.BusinessObjectException)
			{
				//Nothing to do here.. but no test results will display on the report!
			}
			//
			foreach(DataRow dr in _transfusedUnits.Rows)
			{
				//Ignore patient transfusion record if no lab test result returned for the patient
				if (patientLabTestArray.IndexOf(dr[TABLE.Patient.VistaPatientId].ToString())<0)
				{
					continue;
				}
				//
				DataRow drReport = dtReport.NewRow();
				//
				drReport[TABLE.Patient.VistaPatientId] = dr[TABLE.Patient.VistaPatientId];
				string name = BOL.Patient.BuildDisplayName(dr[TABLE.Patient.PatientFirstName].ToString(),
					dr[TABLE.Patient.PatientMiddleName].ToString(),
					dr[TABLE.Patient.PatientLastName].ToString());
				//
				drReport[TABLE.Patient.PatientGuid] = dr[TABLE.Patient.PatientGuid];
				drReport[ARTIFICIAL.PatientDisplayName] = name;
				drReport[TABLE.Patient.DisplayVistaPatientId] = dr[TABLE.Patient.DisplayVistaPatientId];
				drReport[TABLE.Patient.PatientDeathDate] = dr[TABLE.Patient.PatientDeathDate];
				drReport[TABLE.PatientTreatment.PatientLocation] = dr[TABLE.PatientTreatment.PatientLocation];
				//
				drReport[TABLE.BloodUnit.EyeReadableUnitId] = dr[TABLE.BloodUnit.EyeReadableUnitId];
				drReport[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName]+", "+
					BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(dr[TABLE.BloodUnit.LabelTypeCode]),dr[TABLE.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(dr[TABLE.DonationType.DonationTypeCode]),dr[TABLE.BloodUnit.UnitDivisionId].ToString());
				//
				if (!dr.IsNull(ARTIFICIAL.PooledUnitsCount))
				{
					if (Convert.ToInt32(dr[ARTIFICIAL.PooledUnitsCount])>0)
					{
						drReport[TABLE.BloodProduct.ProductShortName] = drReport[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[ARTIFICIAL.PooledUnitsCount].ToString()+")";
					}
				}
				//
				drReport[TABLE.PatientTransfusion.TransfusionEndDateTime] = dr[TABLE.PatientTransfusion.TransfusionEndDateTime];
				drReport["SortDate"] = dr[TABLE.PatientTransfusion.TransfusionEndDateTime];
				//
				dtReport.Rows.Add(drReport);
			}
			//
			string sortString = ARTIFICIAL.PatientDisplayName+", "+
				TABLE.Patient.DisplayVistaPatientId+", "+
				ARTIFICIAL.SortDate+" DESC, "+
				TABLE.BloodUnit.EyeReadableUnitId+", "+
				TABLE.BloodProduct.ProductShortName;
			//
			DataRow[] drSort = dtReport.Select("",sortString);
			this._transfusionEffectivenessReport = dtReport.Clone();
			foreach (DataRow drSorted in drSort)
			{
				this._transfusionEffectivenessReport.Rows.Add(drSorted.ItemArray);
			}
		}

		private DataRow FindPatientInfo(string vistaPatientID)
		{
			DataRow[] drPatients = this._transfusedUnits.Select(TABLE.Patient.VistaPatientId+" = '"+vistaPatientID+"'");
			//
			if (drPatients == null)
			{
				throw new BOL.BusinessObjectException("Patient has no transfused units");
			}
			//
			return drPatients[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7849"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7850"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GenerateReport
		/// </summary>
		/// <returns></returns>
		public DataSet GenerateReport()
		{
			this.GetTransfusionEffectivenessReport();

			DataSet reportDataSet = new DataSet();
			reportDataSet.Tables.Add(this.DetailedReport.Copy());
			reportDataSet.Tables.Add(this._labTests.Copy());

			return reportDataSet;
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7851"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7852"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            _dsReport = this.GenerateReport();
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.ReportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TransfusionEffectivenessDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionEffectiveness.TransfusionEffectivenessReport.rdlc");
            Stream streamTests = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionEffectiveness.TransfusionEffectivenessTests.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("TransfusionEffectivenessTests", streamTests);

            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TransfusionEffectivenessTests" || e.DataSourceNames[0].ToString() == "TransfusionEffectivenessTestsDataSet")
            {
                ReportDataSource reportTests = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportTests.Name = "TransfusionEffectivenessTestsDataSet";
                    reportTests.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportTests);
            }
        }
	}
}
